// BullsEyeCtl.cpp : Implementacja DLL Exports.


// Uwaga: Informacja o Proxy/Stub
//      Aby utworzy oddzieln bibliotek proxy/stub, 
//      wykonaj nmake -f BullsEyeCtlps.mk w katalogu projektu.

#include "stdafx.h"
#include "resource.h"
#include <initguid.h>
#include "BullsEyeCtl.h"

#include "BullsEyeCtl_i.c"
#include "BullsEye.h"
#include "BullsEyePropPage.h"

#include "IDropSourceImpl.h"


CComModule _Module;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_BullsEye, CBullsEye)
OBJECT_ENTRY(CLSID_BullsEyePropPage, CBullsEyePropPage)
END_OBJECT_MAP()

/////////////////////////////////////////////////////////////////////////////
// Punkt wejcia DLL

extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
    if (dwReason == DLL_PROCESS_ATTACH)
    {
        _Module.Init(ObjectMap, hInstance, &LIBID_BullsEyeLib);
        DisableThreadLibraryCalls(hInstance);
    }
    else if (dwReason == DLL_PROCESS_DETACH)
        _Module.Term();
    return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Uywane do ustalenia, czy DLL moe by usunity przez OLE

STDAPI DllCanUnloadNow(void)
{
    return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Zwraca wytwrni klas w celu utworzenia obiektu danego typu

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
    return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Dodaje wpisy do rejestru systemowego

STDAPI DllRegisterServer(void)
{
    // Rejestruje obiekt, typelib i wszystkie interfejsy w typelib
    return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Usuwa wpisy z rejestru systemowego

STDAPI DllUnregisterServer(void)
{
    return _Module.UnregisterServer(TRUE);
}


